<?php

class VideoContentBlock extends ContentBlock
{

  protected static $singular_name = 'Videos Section';
  protected static $plural_name = 'Videos Sections';

  private static $has_many = [
    'Videos' => 'Video',
  ];

  public function getCMSFields()
  {
    $this->beforeUpdateCMSFields(function (FieldList $fields) {
      $GridFieldConfig = new GridFieldConfig_RecordEditor();
      $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
      $GridField = new GridField("CarouselGridField", "Videos", $this->Videos(), $GridFieldConfig);

      $fields->addFieldToTab("Root.Main", $GridField);
    });

    $fields = parent::getCMSFields();

    $fields->removeByName('Videos');

    return $fields;
  }


  public function getRandomVideos($limit = 1)
  {
    return $this->Videos()->sort('RAND()')->limit($limit);
  }
}
