<?php

class Video extends DataObject
{

  private static $extensions = [
    'GenericItemExtension'
  ];

  protected static $db = [
    'Title'     => 'Varchar(255)',
    'YouTubeID' => 'Varchar(255)'
  ];

  protected static $has_one = [
    'ContentBlock' => 'VideoContentBlock',
  ];

  public function getCMSFields()
  {
    $fields = FieldList::create()->build([
      TextField::create('Title', 'Title'),
      TextField::create('YouTubeID', 'YouTube ID')->setDescription('The content of the youtube link after the =. Eg: v= <strong>Cx171...</strong>'),
    ]);

    $this->extend('updateCMSFields', $fields);

    return $fields;
  }

  public function canView($member = null)
  {
    return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
  }

  public function canEdit($member = null)
  {
    return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
  }

  public function canDelete($member = null)
  {
    return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
  }

  public function canCreate($member = null)
  {
    return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
  }
}
