<?php

class VideoBannerContentBlock extends ContentBlock
{

    protected static $singular_name = 'Video Banner';
    protected static $plural_name = 'Video Banners';

    private static $extensions = [
        'FoxysiteModuleExtension'
    ];

    private static $db = [
        'SubTitle' => 'Varchar(255)',
        'VideoID' => 'Varchar(255)',
        'PrimaryContent' => 'HTMLText',
        'SecondaryContent' => 'HTMLText'
    ];

    private static $has_one = [
        'Button' => 'Link',
        'Image' => 'Image'
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function (FieldList $fields) {
            $fields->addFieldsToTab('Root.Banner', [
                TextField::create('SubTitle', 'Sub Title'),
                TextField::create('VideoID', 'YouTube Video ID'),
                LinkField::create('ButtonID', 'Call to Action'),
                UploadField::create('Image', 'Fallback Image')->setDescription('This will always be shown if no Video ID is provided (must be a minimum of 1920px wide)'),
                HtmlEditorField::create('PrimaryContent', 'Primary Content')->setRows(5),
                HtmlEditorField::create('SecondaryContent', 'Secondary Content')->setRows(5),
            ]);
        });

        $fields = parent::getCMSFields();

        return $fields;
    }

    public function forTemplate()
    {
        Requirements::css(FS_VIDEO_BANNER_DIR . '/assets/css/style.css');
        Requirements::javascript(FS_VIDEO_BANNER_DIR . '/assets/js/video.js');
        return parent::forTemplate();
    }

    public function BootstrapTemplate()
    {
        return $this->renderWith('BootstrapVideoBannerContentBlock');
    }
}
