var tag = document.createElement('script');
tag.src = "https://www.youtube.com/player_api";
var firstScriptTag = document.getElementsByTagName('script')[0];
firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

// Mute player: http://stackoverflow.com/questions/24868226/how-do-you-mute-an-embedded-youtube-player

function onPlayerReady(event) {
  player.mute();
  player.playVideo();
}

var player;

// Need to have loop and playlist in order to avoid AS3 issue: https://developers.google.com/youtube/player_parameters#loop

function onYouTubePlayerAPIReady() {
  if (!document.querySelector('#video')) return;
  var id = document.querySelector('[data-video-id]').getAttribute('data-video-id');
  console.log(id);
  player = new YT.Player('video', {
    videoId: id,
    playerVars: {
      'autoplay': 1,
      'loop': 1,
      'playlist': id,
      'controls': 0,
      'showinfo': 0
    },
    events: {
      'onReady': onPlayerReady
    }
  });
}
