<% if $SliderImages.Count > 1 %>
    <div id="slider-{$Block.ID}" class="carousel slide" data-ride="carousel">
        <ol class="carousel-indicators">
            <% loop $SliderImages %>
                <li data-target="#slider-{$Up.Block.ID}" data-slide-to="{$Pos(0)}"
                    <% if $First %>class="active"<% end_if %>></li>
            <% end_loop %>
        </ol>
        <div class="carousel-inner" role="listbox">
            <% loop $SliderImages %>
                <div class="item <% if $First %>active<% end_if %>">
                    <% if $MediaOrientation == 'Horizontal' %>
                        <img class="img-responsive" src="{$Image.Fill(800, 400).Url}" alt="{$Image.AltText}">
                        <div class="carousel-caption">
                            <% if $Title %>
                                <p class="lead">{$Title}</p>
                            <% end_if %>
                            <% if $Caption %>
                                <p>{$Caption}</p>
                            <% end_if %>
                        </div>

                    <% else_if $MediaOrientation == 'Vertical' %>
                        <img class="img-responsive" src="{$Image.PaddedImage(265, 500, FFFFFF).Url}" alt="{$Image.AltText}">
                        <div class="carousel-caption">
                            <% if $Title %>
                                <p class="lead">{$Title}</p>
                            <% end_if %>
                            <% if $Caption %>
                                <p>{$Caption}</p>
                            <% end_if %>
                        </div>
                    <% end_if %>
                </div>
            <% end_loop %>
        </div>
    </div>
<% else %>
    <% with $SliderImages.First %>
        <img class="img-responsive" src="{$Image.Url}" alt="{$Image.AltText}">
    <% end_with %>
<% end_if %>
