<?php

class SliderImage extends DataObject
{
  private static $extensions = [
    'GenericItemExtension',
    'MediaItemExtension'
  ];

  private static $db = [
    'MediaOrientation' => 'Enum("Horizontal,Vertical", "Horizontal")',
  ];

  protected static $has_one = [
    'Slider' => 'TextAndImageContentBlock',
  ];

  public function getCMSFields()
  {



    $this->beforeUpdateCMSFields(function (FieldList $fields) {

      $MediaOrientation = [];
      foreach (singleton(__CLASS__)->dbObject('MediaOrientation')->enumValues() as $type) {
        $MediaOrientation[$type] = ucwords($type);
      }

      $fields->addFieldsToTab('Root.Main', [
        DropdownField::create('MediaOrientation', null, $MediaOrientation),
      ]);
    });

    $fields = FieldList::create()->build();

    $this->extend('updateCMSFields', $fields);

    $fields = parent::getCMSFields();

    $fields->removeByName('SortOrder');
    $fields->removeByName('PageID');
    $fields->removeByName('SliderID');

    return $fields;


  }

  public function canView($member = null)
  {
    return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
  }

  public function canEdit($member = null)
  {
    return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
  }

  public function canDelete($member = null)
  {
    return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
  }

  public function canCreate($member = null)
  {
    return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
  }
}
