<?php

class TextAndImageContentBlock extends ContentBlock
{

    protected static $singular_name = 'Text and Image Section';
    protected static $plural_name = 'Text and Image Sections';

    private static $extensions = [
        'FoxysiteModuleExtension',
        'CustomBlockWidthExtension'
    ];

    private static $db = [
        'Content' => 'HTMLText',
        'MediaPosition' => 'Enum("Left,Right,Top,Bottom", "Left")',
        'SubTitle' => 'Varchar(100)'
    ];

    private static $has_many = [
        'SliderImages' => 'SliderImage',
    ];

    public function getCMSFields()
    {

        $MediaPosition = [];
        foreach (singleton(__CLASS__)->dbObject('MediaPosition')->enumValues() as $type) {
            $MediaPosition[$type] = ucwords($type);
        }

        $fields = Parent::getCMSFields();

        $GridFieldConfig = new GridFieldConfig_RecordEditor();
        $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
        $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
        $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
        $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
        $bulkUploadConfig->setUfSetup('setFolderName', "Images/Slider-Images");
        $GridField = new GridField("SliderGridField", 'Images', $this->SliderImages(), $GridFieldConfig);

        $fields->addFieldToTab("Root.Main", HtmlEditorField::create('Content'));
        $fields->addFieldToTab('Root.Main', DropdownField::create('MediaPosition', null, $MediaPosition)->setDescription('If "Top" or "Bottom" are selected, then the left side width will have no effect'), 'LeftBlockWidth');
        $fields->addFieldToTab('Root.Main', TextField::create('SubTitle', 'Subtitle'), 'Displayed');
        $fields->addFieldToTab("Root.Images", $GridField);

        $fields->removeByName('SliderImages');

        return $fields;
    }

    public function BootstrapTemplate()
    {
        return $this->renderWith('BootstrapTextAndImageContentBlock');
    }
}
