<?php

class TextAndImageContentBlock extends ContentBlock
{

    protected static $singular_name = 'Slider Section';
    protected static $plural_name   = 'Slider Sections';

    private static $extensions = [
        'FoxysiteModuleExtension',
        'CustomBlockWidthExtension'
    ];

    private static $db = [
        'Content' => 'HTMLText',
        'MediaPosition' => 'Enum("Left,Right", "Left")'
    ];

    private static $has_many = [
        'SliderImages' => 'SliderImage',
    ];

    public function getCMSFields()
    {
        $fields = Parent::getCMSFields();

        $GridFieldConfig = new GridFieldConfig_RecordEditor();
        $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
        $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
        $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
        $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
        $bulkUploadConfig->setUfSetup('setFolderName', "Images/Slider-Images");
        $GridField = new GridField("SliderGridField", 'Slider', $this->SliderImages(), $GridFieldConfig);

        $fields->addFieldToTab("Root.Main", HtmlEditorField::create('Content'));
        $fields->addFieldToTab("Root.Slider", $GridField);

        $fields->removeByName('SliderImages');

        return $fields;
    }

    public function BootstrapTemplate()
    {
        return $this->renderWith('BootstrapImageContentBlock');
    }
}
