<?php

class Testimonial extends DataObject
{

    private static $extensions = [
        'GenericItemExtension' 
    ];

    protected static $db = [
        'Position' => 'Varchar(255)',
        'Content'     => 'Text',
    ];

    protected static $has_one = [
        'Testimonial'  => 'TestimonialContentBlock',
        'Image' => 'Image'
    ];

    public function getCMSFields()
    {
        $fields = FieldList::create()->build([
            TextField::create('Position', 'Position / Role'),
            TextareaField::create('Content', 'Content / Testimonial'),
            UploadField::create('Image', 'Image')->setFolderName("Images/Testimonial-Images")
        ]);

        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
