<?php

class TestimonialContentBlock extends ContentBlock
{

    protected static $singular_name = 'Testimonial Section';
    protected static $plural_name   = 'Testimonial Sections';

    private static $extensions = [
        'FoxysiteModuleExtension' 
    ];

    private static $has_many = [
        'Testimonials' => 'Testimonial',
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function(FieldList $fields) {
            $GridFieldConfig = new GridFieldConfig_RecordEditor();
            $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
            $GridField = new GridField("CarouselGridField", "Testimonials", $this->Testimonials(), $GridFieldConfig);

            $fields->addFieldToTab("Root.Main", $GridField);
        });

        $fields = parent::getCMSFields();

        $fields->removeByName('Testimonials');

        return $fields;
    }
}
