<?php

class Testimonial extends DataObject
{
    protected static $db = [
        'Title'     => 'Varchar(255)',
        'Position' => 'Varchar(255)',
        'Content'     => 'Text',
        'Displayed' => 'Boolean',
        'SortOrder' => 'Int'
    ];

    protected static $has_one = [
        'Testimonial'  => 'TestimonialContentBlock',
        'Image' => 'Image'
    ];

    private static $defaults = [
        'Displayed' => true
    ];

    protected static $default_sort = 'SortOrder';

    public function getCMSFields()
    {
        $fields = new FieldList([
            TextField::create('Title', 'Author'),
            TextField::create('Position', 'Position / Role'),
            TextareaField::create('Content', 'Content / Testimonial'),
            DropdownField::create('Displayed', 'Displayed', [1 => 'Displayed', 0 => 'Hidden']),
            UploadField::create('Image', 'Image')->setFolderName("Images/Testimonial-Images")
        ]);
        
        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
