<?php

class TeamContentBlock extends ContentBlock
{

    protected static $singular_name = 'Team Section';
    protected static $plural_name = 'Team Sections';

    private static $db = [
        'ProfileSize' => 'Varchar(50)',
        'ProfileLayout' => 'Varchar(50)'
    ];

    private static $has_many = [
        'TeamMembers' => 'TeamMember',
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function (FieldList $fields) {

            $showTeamProfileSize = $this->owner->config()->get('show_team_profile_size');

            $fields->removeByName('ProfileSize');

            if($showTeamProfileSize) {
                $sizes = [];
                foreach ($this->owner->config()->get('team_profile_sizes') as $size) {
                    $sizes[$size] = ucwords($size);
                }
                $fields->addFieldToTab('Root.Main', DropdownField::create('ProfileSize', 'Profile Size', $sizes)->setEmptyString('Default'));
            }

            $showTeamProfileLayout = $this->owner->config()->get('show_team_profile_layout');

            $fields->removeByName('ProfileLayout');

            if($showTeamProfileLayout) {
                $layouts = [];
                foreach ($this->owner->config()->get('team_profile_layouts') as $layout) {
                    $layouts[$layout] = ucwords($layout);
                }
                $fields->addFieldToTab('Root.Main', DropdownField::create('ProfileLayout', 'Profile Layout', $layouts)->setEmptyString('Default'));
            }

            $GridFieldConfig = new GridFieldConfig_RecordEditor();
            $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
            $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
            $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
            $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
            $bulkUploadConfig->setUfSetup('setFolderName', "Images/Team-Images");
            $GridField = new GridField("CarouselGridField", "TeamMembers", $this->TeamMembers(), $GridFieldConfig);

            $fields->addFieldToTab("Root.Main", $GridField);

        });

        $fields = parent::getCMSFields();

        $fields->removeByName('TeamMembers');

        return $fields;
    }
}
