<?php

class TeamMember extends DataObject
{

    private static $extensions = [
        'GenericItemExtension' 
    ];

    protected static $db = [
        'Description'     => 'Text',
    ];

    protected static $has_one = [
        'Team'  => 'TeamContentBlock',
        'Image' => 'Image'
    ];

    public function getCMSFields()
    {
        $fields = FieldList::create()->build([
            TextareaField::create('Description', 'Description'),
            UploadField::create('Image', 'Image')->setFolderName("Images/Team-Images")
        ]);

        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
