<?php

class TeamContentBlock extends ContentBlock
{

    protected static $singular_name = 'Team Section';
    protected static $plural_name   = 'Team Sections';

    private static $has_many = [
        'TeamMembers' => 'TeamMember',
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function(FieldList $fields) {
            $GridFieldConfig = new GridFieldConfig_RecordEditor();
            $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
            $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
            $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
            $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
            $bulkUploadConfig->setUfSetup('setFolderName', "Images/Team-Images");
            $GridField = new GridField("CarouselGridField", "TeamMembers", $this->TeamMembers(), $GridFieldConfig);

            $fields->addFieldToTab("Root.Main", $GridField);
        });

        $fields = parent::getCMSFields();

        $fields->removeByName('TeamMembers');

        return $fields;
    }
}
