<?php

class SponsorsContentBlock extends ContentBlock
{

    protected static $singular_name = 'Sponsors Section';
    protected static $plural_name   = 'Sponsors Sections';

    private static $extensions = [
        'FoxysiteModuleExtension' 
    ];

    private static $has_many = [
        'Sponsors' => 'Sponsor',
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function(FieldList $fields) {
            $GridFieldConfig = new GridFieldConfig_RecordEditor();
            $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
            $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
            $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
            $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
            $bulkUploadConfig->setUfSetup('setFolderName', "Images/Sponsor-Images");
            $GridField = new GridField("CarouselGridField", "Sponsors", $this->Sponsors(), $GridFieldConfig);

            $fields->addFieldToTab("Root.Main", $GridField);
        });

        $fields = parent::getCMSFields();

        $fields->removeByName('Sponsors');

        return $fields;
    }
}
