<?php

class PricingPlan extends DataObject
{

    private static $extensions = [
        'GenericItemExtension' 
    ];

    protected static $db = [
        'Price' => 'Varchar(255)',
        'Term' => 'Varchar(255)',
        'Description'     => 'Text',
        'Featured' => 'Boolean'
    ];

    protected static $has_one = [
        'ContentBlock'  => 'PricingContentBlock',
        'Link' => 'Link'
    ];

    private static $defaults = [
        'Featured' => false
    ];

    public function getCMSFields()
    {
        $fields = FieldList::create()->build([
            TextField::create('Price', 'Price'),
            TextField::create('Term', 'Term'),
            LinkField::create('LinkID', 'Link'),
            DropdownField::create('Featured', 'Is this a featured item?', [0 => 'Normal', 1 => 'Featured']),
            TextareaField::create('Description', 'Description'),
        ]);

        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
