<?php

class PricingContentBlock extends ContentBlock
{

    protected static $singular_name = 'Pricing Section';
    protected static $plural_name   = 'Pricing Sections';

    private static $extensions = [
        'FoxysiteModuleExtension' 
    ];

    private static $has_many = [
        'PricingPlans' => 'PricingPlan',
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function(FieldList $fields) {
            $GridFieldConfig = new GridFieldConfig_RecordEditor();
            $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
            $GridField = new GridField("CarouselGridField", "PricingPlans", $this->PricingPlans(), $GridFieldConfig);

            $fields->addFieldToTab("Root.Main", $GridField);
        });

        $fields = parent::getCMSFields();

        $fields->removeByName('PricingPlans');

        return $fields;
    }
}
