<?php

/**
 * @method SiteTree Page()
 */
class PortfolioItem extends DataObject
{

	private static $extensions = [
        'GenericItemExtension',
        'MediaItemExtension'
	];

	private static $db = [
		'Caption' => 'Text',
	];

	protected static $has_one = [
		'Portfolio' => 'PortfolioContentBlock',
        'Link' => 'Link',
	];

	protected static $belongs_many_many = [
		'PortfolioCategories' => 'PortfolioCategory'
	];

	public function getCMSFields()
	{

		$CategorySource = function () {
			return PortfolioCategory::get()->map()->toArray();
		};

		$fields = FieldList::create()->build();

		$Category = ListboxField::create('PortfolioCategories', 'Category', $CategorySource());

		$Category->setMultiple(true);
	
		$Category->useAddNew('PortfolioCategory', $CategorySource, new FieldList([
			new HiddenField('PortfolioID', '', $this->PortfolioID),
			new TextField('Title')
		]));

		$this->extend('updateCMSFields', $fields);

		$fields->addFieldsToTab('Root.Main', [
			TextareaField::create('Caption'),
            LinkField::create('LinkID', 'Link'),
			$Category], 'Image');

		return $fields;
	}

	public function canView($member = null)
	{
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canEdit($member = null)
	{
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canDelete($member = null)
	{
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canCreate($member = null)
	{
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}
}
