<?php

class PortfolioContentBlock extends ContentBlock
{

	protected static $singular_name = 'Portfolio Section';
	protected static $plural_name   = 'Portfolio Sections';

    private static $extensions = [
        'FoxysiteModuleExtension'
    ];

	private static $has_many = [
		'PortfolioCategories' => 'PortfolioCategory',
		'PortfolioItems' => 'PortfolioItem' 
	];

	public function getCMSFields()
	{
		$fields = Parent::getCMSFields();

		$fields->removeByName('PortfolioItems');

		$GridFieldConfig = new GridFieldConfig_RecordEditor();
		$GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
		$GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
		$GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
		$GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
		$bulkUploadConfig->setUfSetup('setFolderName', "Images/Portfolio-Images");
		$GridField = new GridField("PortfolioItems", 'Portfolio Items', $this->PortfolioItems(), $GridFieldConfig);

		$fields->addFieldToTab("Root.Main", $GridField);

        $fields->dataFieldByName('PortfolioCategories')->getConfig()
            ->removeComponentsByType('GridFieldAddExistingAutocompleter');

		return $fields;
	}

}
