<?php

class PortfolioCategory extends DataObject
{

	private static $db = [
		'Title' => 'Varchar(255)',
		'SortOrder' => 'Int'
	];

	protected static $has_one = [
		'Portfolio'  => 'PortfolioContentBlock',
	];

	protected static $many_many = [
		'PortfolioItems' => 'PortfolioItem'
	];

	private static $default_sort = 'Title';

	public function getCMSFields()
	{

		$fields = Parent::getCMSFields();

		$fields->removeByName(['SortOrder', 'PortfolioID']);

		return $fields;
	}


	public function canView($member = null)
	{
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canEdit($member = null)
	{
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canDelete($member = null)
	{
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canCreate($member = null)
	{
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}
}
