<?php

/**
 * @method SiteTree Page()
 */
class PortfolioItem extends DataObject
{

    private static $extensions = [
        'MediaItemExtension'
    ];

    private static $db = [
        'Caption' => 'Text',
    ];

    protected static $belongs_many_many = [
        'PortfolioCategories' => 'PortfolioCategory'
    ];

    public function getCMSFields()
    {

        $fields = new FieldList([
            new TabSet('Root'),
        ]);

        $this->extend('updateCMSFields', $fields);

        $fields->addFieldToTab('Root.Main', TextareaField::create('Caption'), 'Image');

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
