<?php

class PortfolioContentBlock extends ContentBlock
{

    protected static $singular_name = 'Portfolio Section';
    protected static $plural_name   = 'Portfolio Sections';

    private static $has_many = [
        'PortfolioCategories' => 'PortfolioCategory'
    ];

    public function getCMSFields()
    {
        $fields = Parent::getCMSFields();

        $GridFieldConfig = new GridFieldConfig_RecordEditor();
        $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
        $GridField = new GridField("CategoriesGridField", 'Portfolio Categories', $this->PortfolioCategories(), $GridFieldConfig);

        $fields->addFieldToTab("Root.Main", $GridField);

        $fields->removeByName('PortfolioCategories');

        return $fields;
    }
}
