<?php

class PortfolioCategory extends DataObject
{

    private static $db = [
        'Title' => 'Varchar(255)',
        'SortOrder' => 'Int',
        'Displayed' => 'Boolean'
    ];

    protected static $has_one = [
        'Portfolio'  => 'PortfolioContentBlock',
    ];

    protected static $many_many = [
        'PortfolioItems' => 'PortfolioItem'
    ];

    protected static $many_many_extraFields = [
       'PortfolioItems' => ['CustomSortOrder' => 'Int'] 
    ];

    public function getCMSFields()
    {

        $GridFieldConfig = new GridFieldConfig_RelationEditor();
        $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
        $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
        $GridFieldConfig->addComponent(new GridFieldSortableRows('CustomSortOrder'));
        $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
        $bulkUploadConfig->setUfSetup('setFolderName', "Images/Portfolio-Images");
        $GridField = new GridField("PortfolioItems", 'Portfolio Items', $this->PortfolioItems(), $GridFieldConfig);

        $fields = new FieldList([
            new TabSet('Root'),
        ]);

        $this->extend('updateCMSFields', $fields);

        $fields->addFieldToTab("Root.Main", TextField::create("Title"));

        $fields->addFieldToTab("Root.Main", $GridField);

        //$fields->removeByName('PortfolioItems');

        return $fields;
    }

    public function SortedPortfolioItems() {
        return $this->PortfolioItems()->sort('CustomSortOrder');
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
