<?php

/**
 * @method SiteTree Page()
 */
class PortfolioItem extends DataObject
{

    private static $extensions = [
        'MediaItemExtension'
    ];

    protected static $has_one = [
        'Portfolio'  => 'PortfolioContentBlock',
    ];

    public function getCMSFields()
    {

        $fields = new FieldList([
            new TabSet('Root')
        ]);
        
        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
