<?php

class PortfolioContentBlock extends ContentBlock
{

    protected static $singular_name = 'Portfolio Section';
    protected static $plural_name   = 'Portfolio Sections';

    private static $has_many = [
        'PortfolioItems' => 'PortfolioItems',
    ];

    public function getCMSFields()
    {
        $fields = Parent::getCMSFields();

        $GridFieldConfig = new GridFieldConfig_RecordEditor();
        $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
        $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
        $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
        $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
        $bulkUploadConfig->setUfSetup('setFolderName', "Images/Portfolio-Images");
        $GridField = new GridField("PortfolioGridField", 'Portfolio', $this->PortfolioItems(), $GridFieldConfig);

        $fields->addFieldToTab("Root.Main", $GridField);

        $fields->removeByName('PortfolioItems');

        return $fields;
    }
}
