$(function () {
    var $profileMaps = $('[data-hook="map"]');

    if ($profileMaps.length) {
        $profileMaps.each(function () {

            var map;
            var $profileMap = $(this);

            var address = $profileMap.data('address');
            var zoom = parseInt($profileMap.data('zoom'));
            var type = $profileMap.data('type');
            var mContent = $profileMap.data('content');

            console.log(zoom);

            map = new GMaps({
                el: this,
                lat: 0,
                lng: 0,
                zoom: zoom,
                mapType: type,
                scrollwheel: false,
                draggable: true,
            });


            GMaps.geocode({
                address: address,
                callback: function (results, status) {
                    if (status == 'OK') {
                        var coordinates = results[0].geometry.location;
                        let lat = coordinates.lat();
                        let lng = coordinates.lng();
                        map.setCenter(lat, lng);
                        map.addMarker({
                            lat: lat,
                            lng: lng,
                            title: address,
                            infoWindow: {
                                content: mContent
                            }
                        });

                    }
                }
            });
        });
    }
});