<?php

class MapContentBlock extends ContentBlock
{

    protected static $singular_name = 'Map Section';
    protected static $plural_name = 'Map Sections';

    private static $extensions = [
        'FoxysiteModuleExtension'
    ];

    private static $db = [
        'MapType' => "Enum('roadmap,satellite,hybrid,terrain','roadmap')",
        'Address' => 'Varchar',
        'MapZoom' => "Enum('0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17', '15')",
        'MarkerContent' => 'HTMLText'
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function (FieldList $fields) {
            $mapTypes = [];
            foreach (singleton(__CLASS__)->dbObject('MapType')->enumValues() as $type) {
                $mapTypes[$type] = ucwords($type);
            }

            $fields->addFieldsToTab('Root.Main', [
                new TextField('Address'),
                new DropdownField('MapZoom', null, singleton(__CLASS__)->dbObject('MapZoom')->enumValues()),
                new DropdownField('MapType', null, $mapTypes),
                (new HTMLEditorField('MarkerContent'))->setRows(15),
            ]);

        });

        $fields = parent::getCMSFields();

        return $fields;
    }
}
