# Foxysite Map

This plugin simply adds the required dataobjects and makes an extension available to automatically add a map module to any page on your site.
This plugin does not do the frontend for you at all as there are so many different options that it's impracticable.


Available variables are pretty self explanatory
`$MapType`
`$Latitude`
`$Longitude`
`$MapZoom`
`$MarkerTitle`
`$MarkerContent`

## Installation Instructions
### Composer  

Run the following to add this module as a requirement and install it via composer.

```bash
composer require "webfox/foxysite-map"
```

Then browse to `/dev/build?flush=all`

## Requirements  

* Silverstripe 3.1+

## Example `MapContentBlock.ss`


    <% if $Latitude && $Longitude %>
        <div id="content-block-{$ID}" class="{$Background}">
            <div class="container-fluid">
                <div class="row">
                    <div id="map{$ID}" class="map"></div>
                </div>
            </div>
        </div>
    
        <script type="text/javascript">
            var mapData = mapData || [];
            mapData.push({
                el:      '#map{$ID}',
                lat:     '{$Latitude}',
                lng:     '{$Longitude}',
                zoom:    parseInt('{$MapZoom}'),
                mapType: '{$MapType}',
                title: '{$MarkerTitle}',
                content: '{$MarkerContent.JS}'
            });
        </script>
    <% end_if %>

## Example for layout `Page.ss`

    <script src="/themes/default/javascript/vendor.js"></script>
    <script src="/themes/default/javascript/layout.js"></script>
    <script src="//maps.google.com/maps/api/js?key=AIzaSyAubW1kwBdbbV0HeK8a8Fa1Xdl5hNgCIPs"></script>

    <script>
        $(function () {
            if (typeof mapData !== 'undefined') {
                $.each(mapData, function (index, data) {
                    var map = map = new GMaps({
                        el:          data.el,
                        lat:         data.lat,
                        lng:         data.lng,
                        zoom:        data.zoom,
                        mapType:     data.mapType,
                        scrollwheel: false,
                        draggable:   false
                    });
                    map.addMarker({
                        lat:        data.lat,
                        lng:        data.lng,
                        title:      data.title,
                        infoWindow: {
                            content: data.content
                        }
                    });
                    if (typeof InteractionControl !== 'undefined') {
                        new InteractionControl(map);
                    }
                });
            }
        });
    </script>

