<?php

class GatewaysContentBlock extends ContentBlock
{

    protected static $singular_name = 'Gateways Section';
    protected static $plural_name = 'Gateways Sections';

    private static $extensions = [
        'FoxysiteModuleExtension'
    ];

    private static $db = [
        'GateWayOneTitle'     => 'Varchar(255)',
        'GateWayOneContent'   => 'HTMLText',
        'GateWayTwoTitle'     => 'Varchar(255)',
        'GateWayTwoContent'   => 'HTMLText',
        'GateWayThreeTitle'   => 'Varchar(255)',
        'GateWayThreeContent' => 'HTMLText'
    ];

    private static $has_one = [
        'GateWayOneImage'   => 'Image',
        'GateWayTwoImage'   => 'Image',
        'GateWayThreeImage' => 'Image',
        'GateWayOneLink'    => 'Link',
        'GateWayTwoLink'    => 'Link',
        'GateWayThreeLink'  => 'Link',
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function (FieldList $fields) {

            $fields->removeByName([
                'GateWayOneTitle',
                'GateWayOneContent',
                'GateWayTwoTitle',
                'GateWayTwoContent',
                'GateWayThreeTitle',
                'GateWayThreeContent',
                'GateWayFourTitle',
                'GateWayFourContent',
                'GateWayOneImage',
                'GateWayOneLinkID',
                'GateWayTwoImage',
                'GateWayTwoLinkID',
                'GateWayThreeImage',
                'GateWayThreeLinkID',
                'GateWayFourImage',
                'GateWayFourLinkID',
            ]);

            $fields->addFieldsToTab('Root.Gateways', [
                ToggleCompositeField::create('GateWayOne', ($this->GatewayOneTitle ?: 'Gateway One'), [
                    TextField::create('GateWayOneTitle', 'Title'),
                    HtmlEditorField::create('GateWayOneContent', 'Content')->setRows(5),
                    UploadField::create('GateWayOneImage', 'Image')->setFolderName('Images/Gateway-Images'),
                    LinkField::create('GateWayOneLinkID', 'Link'),
                ]),
                ToggleCompositeField::create('GateWayTwo', ($this->GatewayTwoTitle ?: 'Gateway Two'), [
                    TextField::create('GateWayTwoTitle', 'Title'),
                    HtmlEditorField::create('GateWayTwoContent', 'Content')->setRows(5),
                    UploadField::create('GateWayTwoImage', 'Image')->setFolderName('Images/Gateway-Images'),
                    LinkField::create('GateWayTwoLinkID', 'Link'),
                ]),
                ToggleCompositeField::create('GateWayThree', ($this->GatewayThreeTitle ?: 'Gateway Three'), [
                    TextField::create('GateWayThreeTitle', 'Title'),
                    HtmlEditorField::create('GateWayThreeContent', 'Content')->setRows(5),
                    UploadField::create('GateWayThreeImage', 'Image')->setFolderName('Images/Gateway-Images'),
                    LinkField::create('GateWayThreeLinkID', 'Link'),
                ]),
                ToggleCompositeField::create('GateWayFour', ($this->GatewayFourTitle ?: 'Gateway Four'), [
                    TextField::create('GateWayFourTitle', 'Title'),
                    HtmlEditorField::create('GateWayFourContent', 'Content')->setRows(5),
                    UploadField::create('GateWayFourImage', 'Image')->setFolderName('Images/Gateway-Images'),
                    LinkField::create('GateWayFourLinkID', 'Link'),
                ])

            ]);
        });

        $fields = parent::getCMSFields();

        $fields->removeByName('TeamMembers');

        return $fields;
    }

    public function getGateway($pos)
    {
        $data = [
            'Page'    => $this,
            'Title'   => $this->{"GateWay{$pos}Title"},
            'Content' => $this->{"GateWay{$pos}Content"},
            'Image'   => $this->{"GateWay{$pos}Image"}(),
            'Link'    => $this->{"GateWay{$pos}Link"}()
        ];

        $this->extend('updateGateways', $data, $pos);

        return ArrayData::create($data);
    }

    public function getGateways()
    {
        return ArrayList::create([
            'GateWayOne'   => $this->getGateway('One'),
            'GateWayTwo'   => $this->getGateway('Two'),
            'GateWayThree' => $this->getGateway('Three'),
            'GateWayFour'  => $this->getGateway('Four'),
        ]);
    }
}

