<?php

class StaticFormNoCaptchaField extends StaticFormField
{
    protected static $singular_name = 'No Captcha Field';
    protected static $plural_name   = 'No Captcha Fields';
    protected static $hide_ancestor = 'StaticNoCaptchaField';

    public function FieldType()
    {
        return 'SpamProtector';
    }

    public function getFormField()
    {

    	return null;
    }

    public function withForm(Form $form){
    	Requirements::javascript('foxysite-forms/js/static-forms.js');
	    $form->enableSpamProtection();
	    $form->Fields()->fieldByName('Captcha')->setAttribute('data-callback', 'staticFormSubmittedPlaceholder');
    }
}