<?php

class StaticFormEmailField extends StaticFormField
{
    protected static $singular_name = 'Email Field';
    protected static $plural_name   = 'Email Fields';
    protected static $hide_ancestor = 'StaticFormField';

    public function FieldType()
    {
        return 'EmailField';
    }

    public function getFormField()
    {
        $field = EmailField::create("Field[{$this->ID}]", ($this->ShowLabels() ? $this->Title : ''));
        if (!$this->ShowLabels()) {
            $field->setAttribute('placeholder', $this->Title . ($this->Required ? '*' : ''));
        }
        return $field;
    }
}