const $form = $('#Form_StaticForm');
window.staticFormSubmittedPlaceholder = function () {
};
window.staticFormSubmitted = function () {
	$form.addClass('hidden');
	$.ajax({
		type: 'POST',
		url: $form.attr('action'),
		dataType: 'json',
		data: $form.serialize(),
		beforeSend: function () {
			//$('.loading-message').removeClass('hidden');
		},
		success: function (data) {
			// $('.loading-message').addClass('hidden');
			if (data.success) {
				$form.html('<div class="alert alert-success" role="alert">' + data.message + '</div>');
				$form.removeClass('hidden');
			} else {
				var messages = [];
				for (var i in data.errors) {
					if (data.errors.hasOwnProperty(i)) {
						messages.push(data.errors[i].message);
					}
				}

				$('.alert.alert-danger').remove();
				$form.prepend('<div class="alert alert-danger" role="alert">' + messages.join('<br />') + '</div>');
				$form.removeClass('hidden');
			}
		}
	});
	return false;
};

$form.on('submit', function (e) {
	e.preventDefault();
	staticFormSubmitted();
	return false;
});