<?php

/**
 * Class StaticFormSubmission
 *
 * @property string $Title
 * @property string $Casting
 * @property mixed $Value
 */
class StaticFormSubmissionValue extends DataObject
{

    protected static $db = [
        'Title'   => 'Varchar',
        'Casting' => 'Varchar',
        'Value'   => 'Text',
    ];

    protected static $has_one = [
        'Submission' => 'StaticFormSubmission'
    ];

    public function getFormField()
    {
        $fieldClass = $this->Casting;
        /** @var FormField $field */
        $field = new $fieldClass("StaticFormSubmissionValue{$this->ID}", $this->Title);
        $field->setValue($this->Value);

        return $field;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_StaticFormSubmissionModelAdmin', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_StaticFormSubmissionModelAdmin', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_StaticFormSubmissionModelAdmin', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_StaticFormSubmissionModelAdmin', 'any', $member);
    }
}