<?php

class StaticFormSubmissionModelAdmin extends ModelAdmin
{

    private static $managed_models = [
        'StaticFormSubmission' => ['title' => 'Submissions']
    ];

    private static $url_segment = 'form-submissions';

    private static $menu_title = 'Form Submissions';

    public function getEditForm($id = null, $fields = null)
    {
        /** @var Form $form */
        $form = parent::getEditForm($id, $fields);

        /** @var GridFieldConfig_RecordEditor $gfConfig */
        $gfConfig = $form->Fields()->fieldByName('StaticFormSubmission')->getConfig();
        $gfConfig->removeComponentsByType('GridFieldExportButton');
        $gfConfig->addComponent(new StaticFormGridFieldExportButton('buttons-before-left'));

        return $form;
    }


}