<?php

class StaticFormGridFieldExportButton extends GridFieldExportButton
{
    /**
     * Generate export fields for CSV.
     *
     * @param GridField $gridField
     * @return array
     */
    public function generateExportFileData($gridField)
    {
        $separator  = $this->csvSeparator;
        $fileData   = '';
        $columnData = array();
        $fieldItems = new ArrayList();
        $items      = $gridField->getList();

        $headers = array();

        // determine the CSV headers. If a field is callable (e.g. anonymous function) then use the
        // source name as the header instead
        $headers = ['Form Name', 'Date Submitted'];
        /** @var StaticFormSubmission $submission */
        foreach ($items as $submission) {
            /** @var StaticFormSubmissionValue $submissionValue */
            foreach ($submission->SubmissionValues() as $submissionValue) {
                if (!in_array($submissionValue->Title, $headers)) $headers[] = $submissionValue->Title;
            }
        }

        if ($this->csvHasHeader) {
            $fileData .= "\"" . implode("\"{$separator}\"", array_values($headers)) . "\"";
            $fileData .= "\n";
        }

        /** @var StaticFormSubmission $submission */
        foreach ($items as $submission) {
            $columnData = array_flip($headers);
            array_walk($columnData, function (&$value, $key) use ($submission) {
                $value = '--';
                if ($key === 'Form Name') $value = $submission->relField('FormName');
                if ($key === 'Date Submitted') $value = $submission->relField('Created');
            });

            /** @var StaticFormSubmissionValue $submissionValue */
            foreach ($submission->SubmissionValues() as $submissionValue) {
                $columnData[$submissionValue->Title] = $submissionValue->relField('Value');
            }

            array_walk($columnData, function (&$value, $key) {
                $value = str_replace(["\r", "\n"], "\n", $value);
                $value = '"' . str_replace('"', '\"', $value) . '"';
            });

            $fileData .= implode($separator, $columnData);
            $fileData .= "\n";

            $submission->destroy();
        }

        return $fileData;
    }
}