<?php

class StaticFormTextField extends StaticFormField
{
    protected static $singular_name = 'Text Field';
    protected static $plural_name   = 'Text Fields';
    protected static $hide_ancestor = 'StaticFormField';

    public function FieldType()
    {
        return 'TextField';
    }

    public function getFormField()
    {
        $field = TextField::create("Field[{$this->ID}]", ($this->ShowLabels() ? $this->Title : ''));
        if (!$this->ShowLabels()) {
            $field->setAttribute('placeholder', $this->Title . ($this->Required ? '*' : ''));
        }
        return $field;
    }
}