<?php

/**
 * Class StaticFormSelectField
 *
 * @method StaticFormSelectFieldOption[]|HasManyList Options()
 */
class StaticFormSelectField extends StaticFormField
{
    protected static $singular_name = 'Select Field';
    protected static $plural_name   = 'Select Fields';
    protected static $hide_ancestor = 'StaticFormField';

    protected static $has_many = [
        'Options' => 'StaticFormSelectFieldOption'
    ];

    public function FieldType()
    {
        return 'TextField';
    }

    public function getFormField()
    {
        $field = new DropdownField("Field[{$this->ID}]", ($this->ShowLabels() ? $this->Title : ''), $this->Options()->map('Value', 'Title')->toArray());
        if (!$this->ShowLabels()) {
            $field->setEmptyString($this->Title . ($this->Required ? '*' : ''));
        }
        return $field;
    }

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function(FieldList $fields){

            if($this->isInDB()){
                $config = GridFieldConfig::create()
                    ->addComponent(new GridFieldButtonRow('before'))
                    ->addComponent(new GridFieldToolbarHeader())
                    ->addComponent(new GridFieldTitleHeader())
                    ->addComponent(new GridFieldEditableColumns())
                    ->addComponent(new GridFieldDeleteAction())
                    ->addComponent(new GridFieldOrderableRows('SortOrder'))
                    ->addComponent(new GridFieldAddNewInlineButton());

                $fields->addFieldToTab('Root.Main', new GridField('Options', 'Options', $this->Options(), $config));
            } else {
                $fields->addFieldToTab('Root.Main', LiteralField::create(
                    'RequiresSaving',
                    '<p class="message warning">You may add options to the field after saving for the first time.</p>'
                ));
            }
        });

        return parent::getCMSFields();
    }


}