<?php

class StaticFormController extends Controller
{

    private static $allowed_actions = [
        'index',
        'save'
    ];

    public function init()
    {
        parent::init();

    }

    public function save(SS_HTTPRequest $request)
    {
        $data = $request->postVars();

        $submission                = new StaticFormSubmission();
        $submission->FormClassName = $data['FormClassName'];
        $submission->FormID        = $data['FormID'];
        $formObject                = $submission->Form();
        $formObjectFields          = $formObject->FormFields();
        $submission->FormName      = $formObject->Title;


        Config::inst()->update('StaticFormField', 'force_labels', true);
        $form = $formObject->Form();
        $form->loadDataFrom($data);
        $errors = $form->getValidator()->validate();
        if (isset($errors) && !empty($errors)) {
            return json_encode([
                'success' => false,
                'errors'  => $errors
            ]);
        }
        Config::inst()->update('StaticFormField', 'force_labels', false);

        $submission->write();
        foreach ($formObjectFields as $formField) {
            $submissionValue               = new StaticFormSubmissionValue();
            $submissionValue->Title        = $formField->Title;
            $submissionValue->Value        = $data['Field'][(string)$formField->ID];
            $submissionValue->Casting      = $formField->FieldType();
            $submissionValue->SubmissionID = $submission->ID;
            $submissionValue->write();
        }

        if ($formObject->EmailAction === 'DefaultEmail') {
            $formObject->CustomEmailAddress = Config::inst()->get('Email', 'default_email');
        }

        if ($formObject->EmailAction === 'DefaultEmail' || $formObject->EmailAction === 'CustomEmail') {
            $email = new Email(Config::inst()->get('Email', 'default_email'), $formObject->CustomEmailAddress);
            $email->setFrom('website@' . (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'webfox.co.nz'));
            $email->setSubject('Form Submission');
            $email->setTemplate('StaticFormSubmissionEmail');
            $email->populateTemplate(['Submission' => $submission]);
            $email->send();
        }

        return json_encode([
            'success' => true,
            'message' => $formObject->ContentAfterSuccess
        ]);
    }

    public function index(SS_HTTPRequest $request)
    {
        die('api hit');
    }

}