<?php

/**
 * Class StaticFormSubmission
 *
 * @property string $FormName
 * @property string $FormClassName
 * @property int $FormID
 *
 * @method HasManyList|StaticFormSubmissionValue[] SubmissionValues()
 */
class StaticFormSelectFieldOption extends DataObject
{

    protected static $db = [
        'Title'     => 'Varchar',
        'Value'     => 'Varchar',
        'SortOrder' => 'Int'
    ];

    protected static $default_sort = 'SortOrder';

    protected static $has_one = [
        'SelectField' => 'StaticFormSelectField'
    ];

    protected static $summary_fields = [
        'Value' => 'Saved Value',
        'Title' => 'Display Text'
    ];

    /**
     * @return StaticFormContentBlock|DataObject
     */
    public function Form()
    {
        return DataObject::get_by_id($this->FormClassName, $this->FormID);
    }

}