<?php

/**
 * Class StaticFormSubmission
 *
 * @property string $FormName
 * @property string $FormClassName
 * @property int $FormID
 *
 * @method HasManyList|StaticFormSubmissionValue[] SubmissionValues()
 */
class StaticFormSubmission extends DataObject
{

    protected static $db = [
        'FormName'      => 'Varchar',
        'FormClassName' => 'Varchar',
        'FormID'        => 'Int'
    ];

    protected static $has_many = [
        'SubmissionValues' => 'StaticFormSubmissionValue'
    ];

    protected static $summary_fields = [
        'FormName'   => 'Form',
        'Created' => 'Date Submitted'
    ];

    protected static $default_sort = 'Created Desc';

    public function getTitle()
    {
        return "Submission for form \"{$this->FormName}\"";
    }

    public function getCMSFields()
    {
        /** @var FieldList $fields */
        $fields = FieldList::create()->build([
            new ReadonlyField('FormName', 'Form Name', $this->FormName),
            new ReadonlyField('Created', 'Submitted On', $this->Created),
            new HeaderField('SubmissionValues', 'Submission Values')
        ]);

        foreach($this->SubmissionValues() as $valueObject){
            /** @var FormField $field */
            $field = $valueObject->getFormField();
            $fields->addFieldToTab('Root.Main', $field);
        }

        return $fields;


    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_StaticFormSubmissionModelAdmin', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return ($this->isInDB() ? false : parent::canEdit($member));
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_StaticFormSubmissionModelAdmin', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_StaticFormSubmissionModelAdmin', 'any', $member);
    }


    /**
     * @return StaticFormContentBlock|DataObject
     */
    public function Form()
    {
        return DataObject::get_by_id($this->FormClassName, $this->FormID);
    }

}