<?php

/**
 * Class StaticFormContentBlock
 *
 * @method HasManyList|StaticFormField[] FormFields()
 * @property string $SubmitButtonText
 */
class StaticFormContentBlock extends ContentBlock
{

    protected static $singular_name = 'Static Form Block';
    protected static $plural_name   = 'Sign Form Blocks';

    protected static $db = [
        'SubmitButtonText'    => 'Varchar',
        'LabelDisplayStyle'   => 'Varchar',
        'ContentBeforeForm'   => 'HTMLText',
        'ContentAfterForm'    => 'HTMLText',
        'ContentAfterSuccess' => 'HTMLText',
        'EmailAction'         => 'Varchar',
        'CustomEmailAddress'  => 'Varchar',
    ];

    protected static $defaults = [
        'EmailAction'         => 'DefaultEmail',
        'SubmitButtonText'    => 'Submit',
        'LabelDisplayStyle'   => 'Label',
        'ContentAfterSuccess' => '<p>Thank you for your submission</p>'
    ];

    protected static $has_one = [
        'BackgroundImage' => 'Image'
    ];

    protected static $has_many = [
        'FormFields' => 'StaticFormField'
    ];

    public function getCMSFields()
    {

        $this->beforeUpdateCMSFields(function (FieldList $fields) {
            $fields->addFieldsToTab('Root.Main', [
                HtmlEditorField::create('ContentBeforeForm', 'Content Before Form')->setRows(8),
                HtmlEditorField::create('ContentAfterForm', 'Content After Form')->setRows(8),
                HtmlEditorField::create('ContentAfterSuccess', 'Content After Successful Submission')->setRows(8),
            ]);

            if ($this->isInDB()) {
                $fields->removeByName('FormFields');

                $fields->addFieldToTab('Root.Form', DropdownField::create('LabelDisplayStyle', 'Labels', ['Label' => 'Visible', 'Placeholder' => 'Hidden']));
                $fields->addFieldToTab('Root.Form', TextField::create('SubmitButtonText', 'Submit Text'));


                $fields->addFieldToTab('Root.Form', DropdownField::create('EmailAction', 'Email submissions?', [
                    'DefaultEmail' => 'To the default email associated with my account',
                    'CustomEmail'  => 'To a different email',
                    'None'         => 'Do not email submissions',
                ]));

                $customEmailAddressField = EmailField::create('CustomEmailAddress', 'Email Address');
                $customEmailAddressField->hideUnless('EmailAction')->isEqualTo("CustomEmail")->end();
                $fields->addFieldToTab('Root.Form', $customEmailAddressField);

                /** @var GridFieldConfig_RecordEditor $config */
                $config = GridFieldConfig_RecordEditor::create();
                $config->removeComponentsByType('GridFieldAddNewButton');
                $config->addComponent(new GridFieldAddNewMultiClass('buttons-before-left'));
                $config->addComponent(new GridFieldOrderableRows('SortOrder'));
                $fields->addFieldToTab('Root.Form', GridField::create('FormFields', 'Form Fields', $this->FormFields(), $config));
            } else {
                $fields->addFieldToTab('Root.Main', LiteralField::create(
                    'RequiresSaving',
                    '<p class="message warning">You may add fields to the form after saving for the first time.</p>')
                );
            }

            $fields->removeByName('Background');
            if (!!($this->owner->config()->get('ShowBackgrounds'))) $fields->addFieldToTab('Root.Main', UploadField::create('BackgroundImage', 'Background'), 'ContentBeforeForm');
        });

        $fields = parent::getCMSFields();

        return $fields;
    }

    public function Form()
    {
        $fields    = FieldList::create([
            HiddenField::create('FormClassName', '', $this->ClassName),
            HiddenField::create('FormID', '', $this->ID),
        ]);
        $actions   = FieldList::create();
        $validator = new RequiredFields();
        foreach ($this->FormFields() as $field) {
            $fields->push($formField = $field->getFormField());
            if ($field->Required) {
                $validator->addRequiredField($formField->getName());
            }
        }

        $actions->push(FormAction::create('Submit', $this->SubmitButtonText));

        $form = new Form(Controller::curr(), 'StaticForm', $fields, $actions, $validator);
        $form->setAttribute('data-hook', 'static-form');
        $submissionRoot = array_flip(Config::inst()->get('Director', 'rules'))['StaticFormController'];
        $form->setFormAction("/{$submissionRoot}/save");

        $this->extend('updateForm', $form);
        return $form;
    }

}