<?php

/**
 * @property string $Title
 * @property boolean $Required
 * @property int $SortOrder
 *
 * @method StaticFormContentBlock Form()
 */
class StaticFormField extends DataObject
{

    protected static $db = [
        'Title'     => 'Varchar',
        'Required'  => 'Boolean',
        'SortOrder' => 'Int',
    ];

    protected static $has_one = [
        'Form' => 'StaticFormContentBlock'
    ];

    protected static $defaults = [
        'Required' => false
    ];

    protected static $default_sort = 'SortOrder';

    protected static $summary_fields = [
        'Title'        => 'Field Title',
        'SingularName' => 'Field Type'
    ];

    /**
     * @throws Exception
     */
    public function FieldType()
    {
        throw new Exception('StaticFormField::FieldType() must be implemented in subclasses');
    }

    /**
     * @return FormField
     * @throws Exception
     */
    public function getFormField()
    {
        throw new Exception('StaticFormField::getFormField() must be implemented in subclasses');
    }

    public function getSingularName()
    {
        return $this->config()->get('singular_name');
    }

    public function ShowLabels()
    {
        return self::config()->get('force_labels') ?: ($this->Form()->LabelDisplayStyle === 'Label');
    }

    public function getCMSFields()
    {
        /** @var FieldList $fields */
        $fields = FieldList::create()->build([
            TextField::create('Title', 'Field Title'),
            DropdownField::create('Required', 'Field Required?', [0 => 'No', 1 => 'Yes'])
        ]);

        $this->extend('updateCMSFields', $fields);
        return $fields;
    }

}