<?php

/**
 * Class StaticFormTextareaField
 *
 * @property int $Rows
 */
class StaticFormTextareaField extends StaticFormField
{
    protected static $singular_name = 'Multi line Text Field';
    protected static $plural_name   = 'Multi line Fields';
    protected static $hide_ancestor = 'StaticFormField';

    protected static $db = [
        'Rows' => 'Int'
    ];

    protected static $defaults = [
        'Rows' => 5
    ];

    public function FieldType()
    {
        return 'TextareaField';
    }

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function (FieldList $fields) {
            $fields->addFieldToTab('Root.Main', NumericField::create('Rows', 'Height of text area (rows)?'));
        });

        return parent::getCMSFields();
    }

    public function getFormField()
    {
        $field = new TextareaField("Field[{$this->ID}]", ($this->ShowLabels() ? $this->Title : ''));
        $field->setRows($this->Rows);
        if (!$this->ShowLabels()) {
            $field->setAttribute('placeholder', $this->Title . ($this->Required ? '*' : ''));
        }
        return $field;
    }
}