<?php

class EventCategory extends DataObject {

	protected static $db = [
		'Title' => 'Varchar(255)',
	];

	private static $has_one = [
		'EventsPage' => 'EventsPage'
	];

	private static $belongs_many_many = array(
		'Events' => 'EventPage'
	);

	private static $extensions = array(
		"EventsObjectsURLSegmentExtension",
	);

	private static $default_sort = 'Title';

	public function getCMSFields() {

		$fields = new FieldList([
			TextField::create('Title')
		]);

		return $fields;

	}

	public function Link(){
		return $this->EventsPage()->Link('category/'.$this->URLSegment);
	}

	public function canView($member = null) {
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canEdit($member = null) {
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canDelete($member = null) {
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

	public function canCreate($member = null) {
		return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
	}

}