<div class="blog__item">

	<div class="blog__header">
		<h2 class="blog__title">
			<a href="{$Link}">
                <% if $MenuTitle %>$MenuTitle
                <% else %>$Title<% end_if %>
			</a>
		</h2>
		<ul class="blog__info">
			<li>
				<i class="fa fa-calendar"></i>
                {$EventDateRange}
			</li>
			<% if $LocationName %>
				<li>
					<i class="fa fa-map"></i>
					{$LocationName}
				</li>
			<% end_if %>
		</ul>
	</div> <!-- / .blog__header -->

	<div class="blog__body">
        <% if $FeaturedImage %>
			<a href="{$Link}">
				<img src="{$FeaturedImage.CroppedImage(340,235).Url}" alt=""
				     class="img-responsive img-article pull-right">
			</a>
        <% end_if %>

        <% if $PreviewText %>
			<p>
                $PreviewText
				<a href="$Link" class="read-more">Read More &gt;</a>
			</p>
        <% else_if $Excerpt %>
			<p>
                $Excerpt
				<a href="$Link" class="read-more">Read More &gt;</a>
			</p>
        <% else %>
			<p>
                $Content
				<a href="$Link" class="read-more">Read More &gt;</a>
			</p>
        <% end_if %>

	</div> <!-- / .blog__body -->
	<hr>
    <% if $Locations.exists %>
		<div class="blog__footer">
			<ul class="blog__tags">
                <% loop $Locations %>
					<li><a href="$Link" title="$Title">$Title</a></li>
                <% end_loop %>
			</ul>
		</div> <!-- / .blog__footer -->
    <% end_if %>

    <% if $Categories.exists %>
		<div class="blog__footer">
			<ul class="blog__tags">
                <% loop $Categories %>
					<li><a href="$Link" title="$Title">$Title</a></li>
                <% end_loop %>
			</ul>
		</div> <!-- / .blog__footer -->
    <% end_if %>

</div>