<?php

class EventPage extends Page
{

	protected static $singular_name = 'Single Event Page';
	protected static $plural_name = 'Single Event Pages';

	protected static $default_parent = 'EventsPage';
	protected static $can_be_root = false;
	private static $default_sort = "EventStartDate DESC";
	private static $show_in_sitetree = false;

	private static $db = [
		"EventStartDate" => "SS_Datetime",
		"EventEndDate"   => "SS_Datetime",
		"EventPricing"   => "HTMLText",
		"LocationName"   => 'Varchar(255)',
		"Latitude"       => 'Varchar(255)',
		"Longitude"      => 'Varchar(255)',
		"PreviewText"    => 'Text',
		"EndDate"        => 'Boolean',
	];

	private static $many_many = array(
		'Locations'  => 'EventLocation',
		'Categories' => 'EventCategory'
	);

	private static $has_one = array(
		"FeaturedImage" => "Image",
	);

	protected static $defaults = [
		'ShowInMenus' => false
	];

	protected static $summary_fields = [
		'Title'              => 'Event Name',
		'EventDateRangeLong' => 'Event Date'
	];

	public function getCMSFields()
	{

		$this->beforeUpdateCMSFields(function (FieldList $fields) {


			$categoriesField = ListboxField::create("Categories", "Categories", $this->Parent()->EventCategories()->map()->toArray())->setMultiple(true);
			$locationsField = ListboxField::create("Locations", "Locations", $this->Parent()->EventLocations()->map()->toArray())->setMultiple(true);

			/** @var DateTimeField $eventStartDateField */
			$eventStartDateField = DatetimeField::create("EventStartDate", "Event Start Date");
			$eventStartDateField->getDateField()->setConfig("showcalendar", true);

			$eventEndDateCheckboxField = CheckboxField::create('EndDate', 'Check if the event has a end date');

			/** @var DatetimeField $eventEndDateField */
			$eventEndDateField = DatetimeField::create("EventEndDate", "Event End Date");
			$eventEndDateField->getDateField()->setConfig("showcalendar", true);
			$eventEndDateField = new DisplayLogicWrapper($eventEndDateField);
			$eventEndDateField->displayIf('EndDate')->isChecked();

			/** @var UploadField $uploadField */
			$uploadField = UploadField::create("FeaturedImage", _t("BlogPost.FeaturedImage", "Featured Image"));
			$uploadField->setFolderName('Images/Events');
			$uploadField->getValidator()->setAllowedExtensions(array('jpg', 'jpeg', 'png', 'gif'));

			$fields->addFieldsToTab('Root.Main', [
				$eventStartDateField,
				$eventEndDateCheckboxField,
				$eventEndDateField,
				$categoriesField,
				$locationsField,
				$uploadField,
			], 'Content');

			$fields->addFieldsToTab('Root.Location', [
				new TextField('LocationName'),
				new TextField('Address'),
//				new TextField('Latitude'),
//				new TextField('Longitude'),
			]);

			$fields->addFieldToTab('Root.Pricing', HtmlEditorField::create('EventPricing', 'Pricing Information'));


		});

		$fields = parent::getCMSFields();

		$fields->removeByName('ContentBlocks');

		$fields->renameField('Content', 'General Information');

		$fields->addFieldToTab('Root.Metadata', (new TextareaField('PreviewText'))->setAttribute('maxlength', 300));

		return $fields;
	}

	public function getCMSValidator()
	{
		return new RequiredFields(
			['EventStartDate']
		);
	}

	public function getEventCategories()
	{
		return $this->Parent()->EventCategories();
	}

	public function getEventLocations()
	{
		return $this->Parent()->EventLocations();
	}

	public function getPastEventsLink()
	{
		return $this->Parent()->getPastEventsLink();
	}

	public function getCurrentEventsLink()
	{
		return $this->Parent()->getCurrentEventsLink();
	}

	public function getEventDateRange()
	{
		/** @var SS_Datetime $startDate */
		$startDate = $this->dbObject("EventStartDate");

		/** @var SS_Datetime $endDate */
		$endDate = $this->dbObject("EventEndDate");

		if ($startDate->Date() === $endDate->Date()) {
			$d1 = $startDate->DayOfMonth(true);
			$m1 = $startDate->ShortMonth();
			$y1 = $startDate->Year();

			return "$d1 $m1 $y1";
		}

		return $startDate->RangeString($endDate, true);
	}

	public function getEventDateRangeLong()
	{
		/** @var SS_Datetime $startDate */
		$startDate = $this->dbObject("EventStartDate");

		/** @var SS_Datetime $endDate */
		$endDate = $this->dbObject("EventEndDate");

		$d1 = $startDate->DayOfMonth(true);
		$m1 = $startDate->Month();
		$y1 = $startDate->Year();
		$t1 = $startDate->Time();
		$t2 = $endDate->Time();

		if (!$this->EndDate && $t1 === '12:00am') {
			return "$d1 $m1 $y1";
		} elseif (!$this->EndDate) {
			return "$d1 $m1 $y1 at $t1";
		} elseif ($t1 == '12:00am' && $t2 == '12:00am' && $startDate->Rfc2822() == $endDate->Rfc2822()) { //same date, time default
			return "$d1 $m1 $y1";
		} elseif ($startDate->Rfc2822() == $endDate->Rfc2822()) { //exact same
			return "$d1 $m1 $y1 / $t1";
		} elseif ($startDate->Full() == $endDate->Full()) { //same date different time
			return "$d1 $m1 $y1 / $t1 - $t2";
		} else return $startDate->RangeString($endDate, true);
	}

	public function getUpcomingEvents()
	{
		return $this->Parent()->getEvents('upcoming')->filter(['ID:not' => $this->ID]);
	}

}

class EventPage_Controller extends Page_Controller
{

}