<?php


/**
 * @property EventsPage $owner
 * @property array $record
 * @property array original
 */
class EventSearchExtension extends Extension
{

    /**
     * @return \HTMLText|\PaginatedList
     */
    public function beforeCallActionHandler(SS_HTTPRequest $request)
    {
        $searchParam = $request->getVar('search');
        $dateStartParam = $request->getVar('date_start');
        $dateEndParam = $request->getVar('date_end');
        if ($searchParam && $dateStartParam && $dateEndParam) {
//            dd('IF');
            $dateFrom = $dateUntil = new Date();
            $dateFrom->setValue($dateStartParam);
            $dateUntil->setValue($dateEndParam);

            return $this->owner->renderWith(['EventsPage', 'Page'], [
                'Query'         => $searchParam,
                'DateFrom'      => $dateFrom,
                'DateUntil'     => $dateUntil,
                'PaginatedList' => $this->SearchResults($request, $searchParam, $dateFrom, $dateUntil)
            ]);
        } elseif ($searchParam) {
//            dd('ELSE IF');
//            dd($this->SearchResults($request, $searchParam));
            return $this->owner->renderWith(['EventsPage', 'Page'], [
                'Query'         => $searchParam,
                'PaginatedList' => $this->SearchResults($request, $searchParam)
            ]);
        }
    }

    /**
     * @param \SS_HTTPRequest $request
     * @param $searchParam
     * @param Date $dateStart
     * @param Date $dateEnd
     * @return PaginatedList
     */
    public function SearchResults(SS_HTTPRequest $request, $searchParam, Date $dateStart = null, Date $dateEnd = null)
    {

        $postsQuery = $this->owner->getEvents('all')->filterAny(array(
            'Title:PartialMatch'   => Convert::raw2sql($searchParam),
            'Content:PartialMatch' => Convert::raw2sql($searchParam)
        ));
        if ($dateStart && $dateEnd) {
            $postsQuery = $postsQuery->filter([
                'EventStartDate:GreaterThanOrEqual' => $dateStart->Format('Y-m-d') . ' 00:00:00',
                'EventEndDate:LessThanOrEqual'      => $dateEnd->Format('Y-m-d') . ' 23:59:59',
            ]);
        }
        $postsQueryCount = clone $postsQuery;
        $posts = new PaginatedList($postsQuery);

        // If pagination is set to '0' then no pagination will be shown.
        if ($this->owner->EventsPerPage > 0) $posts->setPageLength($this->owner->EventsPerPage);
        else $posts->setPageLength($postsQueryCount->count());
        $start = $request->getVar($posts->getPaginationGetVar());
        $posts->setPageStart($start);

        return $posts;
    }
}