<?php

class CtaContentBlock extends ContentBlock
{

    protected static $singular_name = 'Cta Section';
    protected static $plural_name   = 'Cta Sections';

    private static $db = [
        'Title' => 'Varchar(255)',
        'Content' => 'HTMLText'
    ];

    private static $has_one = [
        'Link' => 'Link'
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function(FieldList $fields) {
            $fields->addFieldToTab("Root.Main", TextField::create('Title', 'Title'));
            $fields->addFieldToTab("Root.Main", LinkField::create('LinkID', 'Link'));
            $fields->addFieldToTab("Root.Main", HtmlEditorField::create('Content', 'Content'));
        });

        $fields = parent::getCMSFields();

        return $fields;
    }
}
