<?php

class CustomBlockWidthExtension extends DataExtension
{

    private static $db = [
        'LeftBlockWidth' => 'Enum("3,6,9", "6")'
    ];

    public function updateCmsFields(FieldList $fields)
    {

        parent::updateCMSFields($fields);

        $fields->addFieldsToTab('Root.Main', [
            DropdownField::create('LeftBlockWidth', 'Left Side Width', [
                '3' => '25%', '6' => '50%', '9' => '75%'
            ])
        ], 'Content');

    }

    public function getLeftWidth()
    {
        return ((in_array($this->owner->MediaPosition, ['Top', 'Bottom']))
            ? 12
            : $this->owner->LeftBlockWidth);
    }

    public function getRightWidth()
    {
        return ((in_array($this->owner->MediaPosition, ['Top', 'Bottom']))
            ? 12
            : 12 - $this->owner->LeftBlockWidth);
    }
}
