<?php

/**
 * Base page type
 */
class Page extends SiteTree {

    /**
     * Additional fields which are available to all pages
     * @var array
     */
    private static $db = [
    ];

    /**
     * One to one relations
     * @var array
     */
    private static $has_one = [
        'Hero' => 'Image',
    ];

  private static $casting = [
    'YouTubeShortCodeHandler' => 'HTMLText'
  ];

  /**
   * One to many relations
   * @var array
   */

    private static $has_many = [
        'ContentBlocks' => 'ContentBlock',
    ];

    public function getCMSFields() {

        $this->beforeUpdateCMSFields(function (FieldList $fields) {
            $ContentBlocksConfig = GridFieldConfig_RecordEditor::create();

            $ContentBlocksConfig->removeComponentsByType("GridFieldAddNewButton");
            $ContentBlocksConfig->addComponent($multiClass = new GridFieldAddNewMultiClass());
            $ContentBlocksConfig->addComponent(new GridFieldOrderableRows('SortOrder'));
            $grid    = GridField::create("ContentBlocks", "Content Blocks", $this->ContentBlocks(), $ContentBlocksConfig);
            $multiClass->setTitle('Add New Content Block');
            $classes = $multiClass->getClasses($grid);
            unset($classes['ContentBlock']);

            foreach ($classes as $className => $blockTitle) {
				/** @var ContentBlock $block */
				$block = new $className;
				if ($block->hasMethod('canAddBlock')) {
					if (!$block->canAddBlock($this)) {
						unset($classes[$className]);
					}
				}
			}

            $multiClass->setClasses($classes);

            $fields->addFieldToTab('Root.Main', $grid);

            $showHero = $this->config()->get('show_hero');

            $fields->removeByName('Hero');

            if($showHero) {
                $fields->insertAfter('MenuTitle', UploadField::create('Hero', 'Header Image'));
            }
        });

        $fields = parent::getCMSFields();

        Requirements::customCSS(
            <<<CSS
			.htmleditor label.left {
				width: 100%;
			}
CSS
        );

        $fields->removeByName('Content');

        return $fields;
    }

    /**
     * Validation which is applied to all pages
     * @return RequiredFields
     */
    public function getCMSValidator() {
        return new RequiredFields(
            []
        );
    }

    public function getDisplayedContentBlocks() {
        return $this->ContentBlocks()->filter('Displayed', true);
    }

    public function getHasContentBlocks() {
        return $this->getDisplayedContentBlocks()->Count() > 0;
    }

    /**
     * Returns the site default meta tags
     * This overload also checks if the domain contains one of our non-indexable domains
     * If it does it adds the noindex meta tag.
     *
     * @param bool $includeTitle
     *
     * @return string
     */
    public function MetaTags($includeTitle = true) {
        $tags          = parent::MetaTags($includeTitle);
        $domains       = Config::inst()->get('Development', 'NoIndexDomains');
        $currentDomain = strtolower(Director::protocolAndHost());
        if (is_array($domains) && !empty($domains)) {
            foreach ($domains as $nonIndexableDomain) {
                if (strpos($currentDomain, strtolower($nonIndexableDomain)) !== false) {
                    return $tags . '<meta name="robots" content="noindex">';
                }
            }
        }

        return $tags;
    }

  public static function YouTubeShortCodeHandler($arguments, $content = null, $parser = null)
  {
    // first things first, if we dont have a video ID, then we don't need to
    // go any further
    if (empty($arguments['id'])) {
      return;
    }

    $customise = [];
    /*** SET DEFAULTS ***/
    $customise['YouTubeID'] = $arguments['id'];
    //play the video on page load
    $customise['autoplay'] = false;
    $customise['related']  = false;
    //set the caption

    //overide the defaults with the arguments supplied
    $customise             = array_merge($customise, $arguments);
    $customise['autoplay'] = ($customise['autoplay'] ? 1 : 0);
    $customise['related']  = ($customise['related'] ? 1 : 0);
    $customise['related']  = ($customise['related'] ? 1 : 0);

    //get our YouTube template
    $template = new SSViewer('YouTube');

    //return the customised template
    return $template->process(new ArrayData($customise));

  }

}

/**
 * Base page controller
 */
class Page_Controller extends ContentController
{
  public function init()
  {
    parent::init();

    ShortcodeParser::get()->register('YouTube', ['Page', 'YouTubeShortCodeHandler']);
  }
}